<?php // no direct access
defined('_JEXEC') or die('Restricted access');

$canEdit	= ($this->user->authorize('com_content', 'edit', 'content', 'all') || $this->user->authorize('com_content', 'edit', 'content', 'own'));
?>

<div class="articolo">
	<div class="header">
		<?php if ($this->item->params->get('show_create_date')) : ?>
			<div class="calendario">
				<div class="mese"><?php echo formattaData(JHTML::_('date', $this->item->created, JText::_('DATE_FORMAT_LC3')), 1); ?></div>
				<div class="giorno"><?php echo formattaData(JHTML::_('date', $this->item->created, JText::_('DATE_FORMAT_LC3')), 2); ?></div>
			</div>
		<?php endif; ?>
		<div class="informazioni">
			<?php if ($this->item->params->get('show_title')) : ?>
				<div class="titolo contentheading">
					<div class="wrap">
						<?php if ($this->item->params->get('link_titles') && $this->item->readmore_link != '') : ?>
							<a href="<?php echo $this->item->readmore_link; ?>" class="contentpagetitle<?php echo $this->item->params->get( 'pageclass_sfx' ); ?>">
								<?php echo $this->item->title; ?>
							</a>
						<?php else : ?>
							<?php echo $this->escape($this->item->title); ?>
						<?php endif; ?>
						<?php if ($canEdit) : ?>
							<div class="edit">
								<?php echo JHTML::_('icon.edit', $this->item, $this->item->params, $this->access); ?>
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>
			<div class="dettagli">
				<?php if (($this->item->params->get('show_author')) && ($this->item->author != "")) : ?>
					<span class="autore">
						<?php echo $this->item->created_by_alias ? $this->item->created_by_alias : $this->item->author ?>
					</span>
				<?php endif; ?>
				<?php if (($this->item->params->get('show_category') && $this->item->catid)) : ?>
					<span class="categoria">
						<?php if ($this->item->params->get('show_category') && $this->item->catid) : ?>
								<?php if ($this->item->params->get('link_category')) : ?>
									<?php echo '<a href="'.JRoute::_(ContentHelperRoute::getCategoryRoute($this->item->catslug, $this->item->sectionid)).'">'; ?>
								<?php endif; ?>
								<?php echo $this->item->category; ?>
								<?php if ($this->item->params->get('link_category')) : ?>
									<?php echo '</a>'; ?>
								<?php endif; ?>
						<?php endif; ?>
					</span>
				<?php endif; ?>
				<?php if ( intval($this->item->modified) != 0 && $this->item->params->get('show_modify_date')) : ?>
					<span class="modificato">
						<?php echo JHTML::_('date', $this->item->modified, JText::_('DATE_FORMAT_LC2')); ?>
					</span>
				<?php endif; ?>
				<?php if ($this->item->params->get('show_pdf_icon') || $this->item->params->get('show_print_icon') || $this->item->params->get('show_email_icon')) : ?>
			<span class="icone">
				<?php if ($this->item->params->get('show_pdf_icon')) : ?>
					<?php echo JHTML::_('icon.pdf', $this->item, $this->item->params, $this->access); ?>
				<?php endif; ?>
				<?php if ( $this->item->params->get( 'show_print_icon' )) : ?>
					<?php echo JHTML::_('icon.print_popup', $this->item, $this->item->params, $this->access); ?>
				<?php endif; ?>
				<?php if ($this->item->params->get('show_email_icon')) : ?>
					<?php echo JHTML::_('icon.email', $this->item, $this->item->params, $this->access); ?>
				<?php endif; ?>
			</span>
		<?php endif; ?>
			</div>
		</div>
	</div>
	<?php  if (!$this->item->params->get('show_intro')) :
		echo $this->item->event->afterDisplayTitle;
	endif; ?>
	<?php echo $this->item->event->beforeDisplayContent; ?>
	<div class="middle contentpaneopen <?php if($this->item->state == 0){ echo "system-unpublished"; } ?>">
	<?php if (isset ($this->item->toc)) : ?>
		<?php echo $this->item->toc; ?>
	<?php endif; ?>
	<?php echo $this->item->text; ?>
	</div>
	<div class="footer">
	<?php if ($this->item->params->get('show_readmore') && $this->item->readmore) : ?>
		<div class="leggitutto">
			<a href="<?php echo $this->item->readmore_link; ?>" class="readon<?php echo $this->item->params->get('pageclass_sfx'); ?>">
				<span class="left">
					<span class="right">
						<span class="center">
							<?php if ($this->item->readmore_register) :
								echo JText::_('Register to read more...');
							elseif ($readmore = $this->item->params->get('readmore')) :
								echo $readmore;
							else :
								echo JText::sprintf('Read more...');
							endif; ?>
						</span>
					</span>
				</span>
			</a>
		</div>
	<?php endif; ?>
	<?php if ($this->item->params->get('show_url') && $this->item->urls) : ?>
		<a href="http://<?php echo $this->item->urls; ?>" target="_blank">
			<?php echo $this->item->urls; ?>
		</a>
	<?php endif; ?>
	</div>
</div>

<span class="article_separator">&nbsp;</span>
<?php echo $this->item->event->afterDisplayContent; ?>
