// Classico JS Tools

Classico = {
	init: function() {
		Classico.ultimaVoce();
		Classico.loginPanel();
		Classico.fontTools();
	},
	ultimaVoce: function() {
		var listaClax = JSMonkey.getElementsByClass("clax", document);
		var listaUl = new Array();
		var listaLi = new Array();
		
		for(var i=0; i < listaClax.length; i++) {
			listaUl = listaClax[i].getElementsByTagName("ul");
			for(var j=0; j < listaUl.length; j++) {
				listaLi = listaUl[j].getElementsByTagName("li");
				JSMonkey.addClass("last-child", listaLi[listaLi.length-1]);
			}
		}
	},
	loginPanel: function() {
		var loginDiv = document.getElementById("login");
		var ulVoci = JSMonkey.getElementsByClass("voci", loginDiv)[0];
		var iconLi = ulVoci.parentNode;
		var wrapperDiv = document.getElementById("wrapper-h2");
		
		function mouseClick() {
			if(!JSMonkey.searchClass("visible", ulVoci)) {
				JSMonkey.addClass("visible", ulVoci);
			}
			else {
				JSMonkey.removeClass("visible", ulVoci);
			}
		}
		
		function mouseOut() {
			if(JSMonkey.searchClass("visible", ulVoci)) {
				function remove() {
					JSMonkey.removeClass("visible", ulVoci);
				}
				setTimeout(remove, 500);
			}
		}
		
		JSMonkey.addEventListener(iconLi, "click", mouseClick);
		JSMonkey.addEventListener(wrapperDiv, "mouseover", mouseOut);
	},
	fontTools: function() {
		var fbig = document.getElementById("fbig");
		var fnor = document.getElementById("fnor");
		var fsma = document.getElementById("fsma");
		
		var content = document.getElementById("content");
		var listaMiddle = JSMonkey.getElementsByClass("middle", content);
		
		var listaClax = JSMonkey.getElementsByClass("clax", document);
		var claxContent = new Array();
		
		var toolbar = document.getElementById("toolbar");
		var listaLi = JSMonkey.getElementsByClass("parent", toolbar);
		
		
		function up() {
			for(var i=0; i < listaMiddle.length; i++) {
				listaMiddle[i].style.fontSize = "15px";
			}
			for(var i=0; i < listaClax.length; i++) {
				claxContent = JSMonkey.getElementsByClass("content", listaClax[i]);
				claxContent[0].style.fontSize = "13px";
			}
			for(var i=0; i < listaLi.length; i++) {
				listaLi[i].getElementsByTagName("ul")[0].style.fontSize = "13px";
			}
			
			JSMonkey.addClass("active", fbig);
			JSMonkey.removeClass("active", fnor);
			JSMonkey.removeClass("active", fsma);
			
			JSMonkey.scriviCookie("jf_classico", "up", 7);
		}
		
		function nor() {
			for(var i=0; i < listaMiddle.length; i++) {
				listaMiddle[i].style.fontSize = "12px";
			}
			for(var i=0; i < listaClax.length; i++) {
				claxContent = JSMonkey.getElementsByClass("content", listaClax[i]);
				claxContent[0].style.fontSize = "11px";
			}
			for(var i=0; i < listaLi.length; i++) {
				listaLi[i].getElementsByTagName("ul")[0].style.fontSize = "11px";
			}
			
			JSMonkey.removeClass("active", fbig);
			JSMonkey.addClass("active", fnor);
			JSMonkey.removeClass("active", fsma);
			
			JSMonkey.cancellaCookie("jf_classico");
		}
		
		function low() {
			for(var i=0; i < listaMiddle.length; i++) {
				listaMiddle[i].style.fontSize = "10px";
			}
			for(var i=0; i < listaClax.length; i++) {
				claxContent = JSMonkey.getElementsByClass("content", listaClax[i]);
				claxContent[0].style.fontSize = "9px";
			}
			for(var i=0; i < listaLi.length; i++) {
				listaLi[i].getElementsByTagName("ul")[0].style.fontSize = "9px";
			}
			
			JSMonkey.removeClass("active", fbig);
			JSMonkey.removeClass("active", fnor);
			JSMonkey.addClass("active", fsma);
			
			JSMonkey.scriviCookie("jf_classico", "low", 7);
		}
		
		switch(JSMonkey.leggiCookie("jf_classico")) {
			case "up": up();
			break;
			case "low": low();
			break;
			default: nor();
			break;
		}
		
		JSMonkey.addEventListener(fbig, "click", up);
		JSMonkey.addEventListener(fnor, "click", nor);
		JSMonkey.addEventListener(fsma, "click", low);
	}
}

JSMonkey.addEventListener(window, "load", Classico.init);