// JSMonkey (Javascript Tools Library by JOOFORGE.com)

JSMonkey = {
	addEventListener: function(target, evento, azione) {
		if(typeof addEventListener != "undefined") {
			target.addEventListener(evento, azione, false);
		}
		else if(typeof attachEvent != "undefined") {
			target.attachEvent("on" + evento, azione);
		}
	},
	getElementsByClass: function(classe, target) {
		var listaElementi = new Array();
		if(target.all) {
			listaElementi = target.all;
		}
		else if(target.getElementsByTagName("*")) {
			listaElementi = target.getElementsByTagName("*");
		}
		var pattern = new RegExp("(^| )" + classe + "( |$)");
		var listaTrovati = new Array();
		for(var i=0; i < listaElementi.length; i++) {
			if(pattern.test(listaElementi[i].className)) {
				listaTrovati[listaTrovati.length] = listaElementi[i];
			}
		}
		return listaTrovati;
	},
	addClass: function(classe, target) {
		if(target.className == "") {
			target.className = classe;
		}
		else {
			target.className += " " + classe;
		}
	},
	removeClass: function(classe, target) {
		var pattern = new RegExp("(^| )" + classe + "( |$)");
		target.className = target.className.replace(pattern, "");
	},
	searchClass: function(classe, target) {
		var pattern = new RegExp("(^| )" + classe + "( |$)");
		return pattern.test(target.className);
	},
	scriviCookie: function(nome, valore, durata) {
		var scadenza = new Date();
		scadenza.setDate(scadenza.getDate() + durata);
		
		var stringa = nome + "=" + escape(valore) + ";expires=" + scadenza.toGMTString();
		document.cookie = stringa;
	},
	leggiCookie: function(nome) {
		var inizio = document.cookie.indexOf(nome + "=");
		var lunghezza = inizio + nome.length + 1;
		var fine = document.cookie.indexOf(";", lunghezza);
		
		if((!inizio) && (nome != document.cookie.substring(0, nome.length))) {
			return null;
		}
		if(inizio == -1) {
			return null
		}
		if(fine == -1) {
			fine = document.cookie.length;
		}
		
		var valore = unescape(document.cookie.substring(lunghezza, fine));
		return valore;
	},
	cancellaCookie: function(nome) {
		if(JSMonkey.leggiCookie(nome)) {
			document.cookie = nome + "=" + ";expires=Thu, 01-Jan-70 00:00:01 GMT";
		}
	}
}
